/*
 * Decompiled with CFR 0.152.
 */
package Controllers;

import Models.Components;
import Models.Pokemon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Controller
extends JFrame {
    Components varData = new Components();
    Pokemon pokemons = new Pokemon();
    public static int selectedSpecies;
    public static int selectedGeneration;
    public static int selectedGame;
    private int selectedBall;
    private int levelOpponent;
    private double statusMultiplier;
    private double oPowerMultiplier;
    private double ballMultiplier;
    private double multiplier;
    private double roundedCatchProbability;
    private JButton btnCalc;
    private JComboBox cbxBall;
    private JComboBox cbxGame;
    private JComboBox cbxGeneration;
    private JComboBox cbxInput1;
    private JComboBox cbxInput2;
    private JComboBox cbxOPower;
    private JComboBox cbxSpecies;
    private JComboBox cbxStatus;
    private JLabel lblBall;
    private JLabel lblBonusses;
    private JLabel lblCave;
    private JLabel lblChance;
    private JLabel lblCurrent;
    private JLabel lblGame;
    private JLabel lblGameQuestion;
    private JLabel lblGeneration;
    private JLabel lblHP;
    private JLabel lblMax;
    private JLabel lblOPower;
    private JLabel lblSpecies;
    private JLabel lblSpeciesQuestion;
    private JLabel lblStatus;
    private JLabel lblVariable;
    private JPanel pnlBonusses;
    private JPanel pnlCalculator;
    private JPanel pnlGame;
    private JPanel pnlHP;
    private JPanel pnlSpecies;
    private JPanel pnlVariables;
    private JTextField txtCurrent;
    private JTextField txtInput1;
    private JTextField txtMax;

    public Controller() {
        this.createComponents();
        this.componentProperties();
        this.setComponentVisibility(false, false, false, false, false);
        this.setDefaultModels();
        this.addingListeners();
    }

    private void createComponents() {
        this.pnlGame = new JPanel();
        this.pnlSpecies = new JPanel();
        this.pnlHP = new JPanel();
        this.pnlBonusses = new JPanel();
        this.pnlVariables = new JPanel();
        this.pnlCalculator = new JPanel();
        this.cbxGame = new JComboBox();
        this.cbxGeneration = new JComboBox();
        this.cbxSpecies = new JComboBox();
        this.txtMax = new JTextField();
        this.txtCurrent = new JTextField();
        this.cbxBall = new JComboBox();
        this.txtInput1 = new JTextField();
        this.cbxInput1 = new JComboBox();
        this.cbxInput2 = new JComboBox();
        this.cbxStatus = new JComboBox();
        this.cbxOPower = new JComboBox();
        this.btnCalc = new JButton();
        this.lblSpecies = new JLabel();
        this.lblGeneration = new JLabel();
        this.lblSpeciesQuestion = new JLabel();
        this.lblCurrent = new JLabel();
        this.lblMax = new JLabel();
        this.lblHP = new JLabel();
        this.lblBonusses = new JLabel();
        this.lblBall = new JLabel();
        this.lblStatus = new JLabel();
        this.lblOPower = new JLabel();
        this.lblVariable = new JLabel();
        this.lblCave = new JLabel();
        this.lblChance = new JLabel();
        this.lblGame = new JLabel();
        this.lblGameQuestion = new JLabel();
    }

    private void componentProperties() {
        this.pnlGame.setLayout(null);
        this.pnlGame.setOpaque(true);
        this.pnlSpecies.setLayout(null);
        this.pnlSpecies.setOpaque(true);
        this.pnlHP.setLayout(null);
        this.pnlHP.setOpaque(true);
        this.pnlBonusses.setLayout(null);
        this.pnlBonusses.setOpaque(true);
        this.pnlVariables.setLayout(null);
        this.pnlVariables.setOpaque(true);
        this.pnlCalculator.setLayout(null);
        this.pnlCalculator.setOpaque(true);
        this.lblGame.setText("Game");
        this.lblGameQuestion.setText("What game are you playing?");
        this.lblSpecies.setText("Species");
        this.lblSpeciesQuestion.setText("Species");
        this.lblGeneration.setText("Generation");
        this.lblHP.setText("HP");
        this.lblCurrent.setText("Current:");
        this.lblMax.setText("Maximum:");
        this.lblBonusses.setText("Bonusses");
        this.lblBall.setText("Ball:");
        this.lblStatus.setText("Status:");
        this.lblOPower.setText("O-Power level:");
        this.lblVariable.setText("");
        this.lblCave.setText("");
        this.lblChance.setText("");
        this.btnCalc.setText("Calculate chance to catch");
        this.pnlGame.add(this.lblGame);
        this.pnlGame.add(this.lblGameQuestion);
        this.pnlGame.add(this.cbxGame);
        this.pnlSpecies.add(this.lblSpecies);
        this.pnlSpecies.add(this.lblSpeciesQuestion);
        this.pnlSpecies.add(this.lblGeneration);
        this.pnlSpecies.add(this.cbxGeneration);
        this.pnlSpecies.add(this.cbxSpecies);
        this.pnlHP.add(this.lblHP);
        this.pnlHP.add(this.lblCurrent);
        this.pnlHP.add(this.lblMax);
        this.pnlHP.add(this.txtCurrent);
        this.pnlHP.add(this.txtMax);
        this.pnlBonusses.add(this.lblBonusses);
        this.pnlBonusses.add(this.lblBall);
        this.pnlBonusses.add(this.lblStatus);
        this.pnlBonusses.add(this.lblOPower);
        this.pnlBonusses.add(this.cbxBall);
        this.pnlBonusses.add(this.cbxStatus);
        this.pnlBonusses.add(this.cbxOPower);
        this.pnlBonusses.add(this.pnlVariables);
        this.pnlVariables.add(this.lblVariable);
        this.pnlVariables.add(this.lblCave);
        this.pnlVariables.add(this.txtInput1);
        this.pnlVariables.add(this.cbxInput1);
        this.pnlVariables.add(this.cbxInput2);
        this.pnlCalculator.add(this.btnCalc);
        this.pnlCalculator.add(this.lblChance);
        this.pnlGame.setBounds(10, 15, 700, 50);
        this.pnlSpecies.setBounds(10, 76, 700, 50);
        this.pnlHP.setBounds(10, 137, 700, 110);
        this.pnlBonusses.setBounds(10, 258, 700, 137);
        this.pnlVariables.setBounds(270, 30, 420, 100);
        this.pnlCalculator.setBounds(10, 406, 700, 40);
        this.lblSpecies.setBounds(0, 0, 60, 20);
        this.lblGeneration.setBounds(0, 20, 80, 20);
        this.lblSpeciesQuestion.setBounds(290, 20, 60, 20);
        this.lblMax.setBounds(10, 80, 80, 20);
        this.lblCurrent.setBounds(10, 40, 80, 20);
        this.lblBonusses.setBounds(0, 0, 60, 30);
        this.lblBall.setBounds(10, 40, 40, 20);
        this.lblStatus.setBounds(10, 70, 80, 20);
        this.lblOPower.setBounds(10, 100, 120, 20);
        this.lblVariable.setBounds(50, 10, 180, 20);
        this.lblCave.setBounds(50, 40, 180, 20);
        this.lblGame.setBounds(0, 0, 50, 20);
        this.lblGameQuestion.setBounds(0, 20, 200, 20);
        this.lblChance.setBounds(250, 10, 500, 20);
        this.lblHP.setBounds(0, 0, 20, 30);
        this.cbxGame.setBounds(220, 20, 100, 20);
        this.cbxSpecies.setBounds(360, 20, 260, 20);
        this.cbxBall.setBounds(130, 40, 180, 20);
        this.cbxStatus.setBounds(130, 70, 180, 20);
        this.cbxOPower.setBounds(130, 100, 180, 20);
        this.cbxInput1.setBounds(180, 10, 190, 20);
        this.cbxInput2.setBounds(180, 40, 190, 20);
        this.cbxGeneration.setBounds(80, 20, 200, 20);
        this.txtInput1.setBounds(180, 10, 190, 25);
        this.txtMax.setBounds(130, 80, 200, 25);
        this.txtCurrent.setBounds(130, 40, 200, 25);
        this.btnCalc.setBounds(10, 10, 210, 30);
        this.add(this.pnlGame);
        this.add(this.pnlSpecies);
        this.add(this.pnlHP);
        this.add(this.pnlBonusses);
        this.add(this.pnlCalculator);
    }

    private void setComponentVisibility(boolean variable, boolean cave, boolean text1, boolean cbx1, boolean cbx2) {
        this.lblVariable.setVisible(variable);
        this.lblCave.setVisible(cave);
        this.txtInput1.setVisible(text1);
        this.cbxInput1.setVisible(cbx1);
        this.cbxInput2.setVisible(cbx2);
    }

    private void setDefaultModels() {
        this.cbxBall.setModel(this.varData.getBallOptions());
        this.cbxGame.setModel(this.varData.getGameOptions());
        this.cbxGeneration.setModel(this.varData.getGenSelect());
        this.cbxOPower.setModel(this.varData.getoPowerOptions());
        this.cbxStatus.setModel(this.varData.getStatusOptions());
        this.cbxSpecies.setModel(this.varData.getGen1species());
        this.cbxInput1.setModel(this.varData.getEmptySelect());
        this.cbxInput2.setModel(this.varData.getEmptySelect());
    }

    private void addingListeners() {
        this.cbxGeneration.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Controller.this.anotherGenerationSelected();
                selectedGeneration = Controller.this.cbxGeneration.getSelectedIndex();
            }
        });
        this.cbxSpecies.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                selectedSpecies = Controller.this.cbxSpecies.getSelectedIndex();
            }
        });
        this.cbxGame.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                selectedGame = Controller.this.cbxGame.getSelectedIndex();
            }
        });
        this.cbxBall.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Controller.this.anotherBallSelected();
                Controller.this.selectedBall = Controller.this.cbxBall.getSelectedIndex();
            }
        });
        this.btnCalc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Controller.this.calculateCatchRate();
            }
        });
        this.txtMax.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Controller.this.txtMax.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.txtCurrent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Controller.this.txtCurrent.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.txtInput1.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Controller.this.txtInput1.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
    }

    private void anotherGenerationSelected() {
        if (this.cbxGeneration.getSelectedIndex() == 0) {
            this.cbxSpecies.setModel(this.varData.getGen1species());
        } else if (this.cbxGeneration.getSelectedIndex() == 1) {
            this.cbxSpecies.setModel(this.varData.getGen2species());
        } else if (this.cbxGeneration.getSelectedIndex() == 2) {
            this.cbxSpecies.setModel(this.varData.getGen3species());
        } else if (this.cbxGeneration.getSelectedIndex() == 3) {
            this.cbxSpecies.setModel(this.varData.getGen4species());
        } else if (this.cbxGeneration.getSelectedIndex() == 4) {
            this.cbxSpecies.setModel(this.varData.getGen5species());
        } else if (this.cbxGeneration.getSelectedIndex() == 5) {
            this.cbxSpecies.setModel(this.varData.getGen6species());
        }
        selectedSpecies = this.cbxSpecies.getSelectedIndex();
    }

    private void anotherBallSelected() {
        switch (this.cbxBall.getSelectedIndex()) {
            case 6: {
                this.lblVariable.setText("Opponent level?");
                this.setComponentVisibility(true, false, true, false, false);
                break;
            }
            case 7: {
                this.lblVariable.setText("Caught before?");
                this.setComponentVisibility(true, false, false, true, false);
                this.cbxInput1.setModel(this.varData.getSimpleSelect());
                break;
            }
            case 8: {
                this.lblVariable.setText("Turn number?");
                this.setComponentVisibility(true, false, true, false, false);
                break;
            }
            case 11: {
                this.lblVariable.setText("Water or land?");
                this.setComponentVisibility(true, false, false, true, false);
                this.cbxInput1.setModel(this.varData.getDivingSelect());
                break;
            }
            case 12: {
                this.lblCave.setText("Are you in a cave?");
                this.lblVariable.setText("Day or night?");
                this.setComponentVisibility(true, true, false, true, true);
                this.cbxInput1.setModel(this.varData.getTimerSelect());
                this.cbxInput2.setModel(this.varData.getSimpleSelect());
                break;
            }
            case 13: {
                this.lblVariable.setText("First turn?");
                this.setComponentVisibility(true, false, false, true, false);
                this.cbxInput1.setModel(this.varData.getQuickSelect());
                break;
            }
            default: {
                this.lblVariable.setText("");
                this.setComponentVisibility(false, false, false, false, false);
                this.cbxInput1.setModel(this.varData.getEmptySelect());
                this.cbxInput2.setModel(this.varData.getEmptySelect());
            }
        }
    }

    private void ballCheck() {
        this.ballMultiplier = 0.0;
        this.multiplier = 0.0;
        this.selectedBall = this.cbxBall.getSelectedIndex();
        switch (this.selectedBall) {
            case 1: {
                this.ballMultiplier = 1.5;
                break;
            }
            case 2: {
                this.ballMultiplier = 2.0;
                break;
            }
            case 4: {
                this.ballMultiplier = 1.5;
                break;
            }
            case 5: {
                if (this.pokemons.isWaterOrBug()) {
                    this.ballMultiplier = 3.0;
                    break;
                }
                this.ballMultiplier = 1.0;
                break;
            }
            case 6: {
                this.levelOpponent = Integer.parseInt(this.txtInput1.getText());
                this.multiplier = (41 - this.levelOpponent) / 10;
                if (this.multiplier <= 1.0) {
                    this.ballMultiplier = 1.0;
                    break;
                }
                this.ballMultiplier = this.multiplier;
                break;
            }
            case 7: {
                if (this.cbxInput1.getSelectedIndex() == 1) {
                    this.ballMultiplier = 3.0;
                    break;
                }
                this.ballMultiplier = 1.0;
                break;
            }
            case 8: {
                double numberOfTurns = Double.parseDouble(this.txtInput1.getText()) - 1.0;
                if (numberOfTurns == -1.0) {
                    numberOfTurns = 0.0;
                }
                this.multiplier = 1.0 + numberOfTurns * 1229.0 / 4096.0;
                if (this.multiplier >= 4.0) {
                    this.ballMultiplier = 4.0;
                    break;
                }
                if (this.multiplier < 1.0) {
                    this.ballMultiplier = 1.0;
                    break;
                }
                this.ballMultiplier = this.multiplier;
                break;
            }
            case 11: {
                if (this.cbxInput1.getSelectedIndex() != 0) {
                    this.ballMultiplier = 3.5;
                    break;
                }
                this.ballMultiplier = 1.0;
                break;
            }
            case 12: {
                if (this.cbxInput1.getSelectedIndex() == 1 || this.cbxInput2.getSelectedIndex() == 1) {
                    this.ballMultiplier = 3.5;
                    break;
                }
                this.ballMultiplier = 1.0;
                break;
            }
            case 13: {
                if (this.cbxInput1.getSelectedIndex() == 0) {
                    this.ballMultiplier = 5.0;
                    break;
                }
                this.ballMultiplier = 1.0;
                break;
            }
            default: {
                this.ballMultiplier = 1.0;
            }
        }
    }

    private void oPowerCheck() {
        int selectPowerLevel = this.cbxOPower.getSelectedIndex();
        switch (selectPowerLevel) {
            case 0: {
                this.oPowerMultiplier = 1.0;
                break;
            }
            case 1: {
                this.oPowerMultiplier = 1.5;
                break;
            }
            case 2: {
                this.oPowerMultiplier = 2.0;
                break;
            }
            case 3: {
                this.oPowerMultiplier = 2.5;
                break;
            }
            case 4: {
                this.oPowerMultiplier = 2.5;
                break;
            }
            case 5: {
                this.oPowerMultiplier = 3.5;
            }
        }
    }

    private void statusCheck() {
        int selectedStatus = this.cbxStatus.getSelectedIndex();
        switch (selectedStatus) {
            case 0: {
                this.statusMultiplier = 1.0;
                break;
            }
            case 1: {
                this.statusMultiplier = 2.5;
                break;
            }
            default: {
                this.statusMultiplier = 1.5;
            }
        }
    }

    private void calculateCatchRate() {
        this.statusCheck();
        this.oPowerCheck();
        this.pokemons.pokeProperties();
        try {
            int maxHP = Integer.parseInt(this.txtMax.getText());
            int currentHP = Integer.parseInt(this.txtCurrent.getText());
            this.ballCheck();
            if (this.selectedBall == 3) {
                double catchProbability = 100.0;
                this.lblChance.setText("The chance to capture the Pok\u00e9mon is " + catchProbability + "%");
            } else {
                double catchProbability = this.ballMultiplier * this.statusMultiplier * this.oPowerMultiplier * this.pokemons.getCatchRate() * (double)(3 * maxHP - 2 * currentHP) / (double)(3 * maxHP * 255) * 100.0;
                this.roundedCatchProbability = (double)Math.round(catchProbability * 10.0) / 10.0;
                this.lblChance.setText("The chance to capture the Pok\u00e9mon is " + this.roundedCatchProbability + "%");
            }
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this, "The text boxes have to be filled with numbers!!");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Make sure you fill out all text boxes!");
        }
    }
}

