/*
 * Decompiled with CFR 0.152.
 */
package pkg_seedchecker;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import pkg_seedchecker.FileDownloader;

public class SEEDChecker
extends JFrame {
    Timer timer;
    private JButton btn_Cancel;
    private JButton btn_Check;
    private JComboBox<String> cbx_Interval;
    private JLabel lbl_Country;
    private JLabel lbl_Interval;
    private JLabel lbl_titleID;
    private JPanel pnl_Main;
    private JTextField txt_Country;
    private JTextField txt_titleID;

    public SEEDChecker() {
        this.initComponents();
        this.setIcon();
    }

    private void setIcon() {
        URL iconURL = this.getClass().getResource("res/icon.png");
        ImageIcon icon = new ImageIcon(iconURL);
        this.setIconImage(icon.getImage());
    }

    private void iniateTimer() {
        this.timer = new Timer();
    }

    private void initComponents() {
        this.pnl_Main = new JPanel();
        this.btn_Check = new JButton();
        this.txt_titleID = new JTextField();
        this.txt_Country = new JTextField();
        this.lbl_Country = new JLabel();
        this.lbl_titleID = new JLabel();
        this.cbx_Interval = new JComboBox();
        this.lbl_Interval = new JLabel();
        this.btn_Cancel = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("SEEDChecker");
        this.setName("SEEDChecker");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent evt) {
                SEEDChecker.this.formWindowOpened(evt);
            }
        });
        this.btn_Check.setText("Start SEED Checking");
        this.btn_Check.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SEEDChecker.this.btn_CheckActionPerformed(evt);
            }
        });
        this.txt_titleID.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SEEDChecker.this.txt_titleIDFocusGained(evt);
            }
        });
        this.txt_Country.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SEEDChecker.this.txt_CountryFocusGained(evt);
            }
        });
        this.lbl_Country.setText("Country code (ISO Alpha 2 code)");
        this.lbl_titleID.setText("Title ID");
        this.cbx_Interval.setModel(new DefaultComboBoxModel<String>(new String[]{"2 Seconds", "5 Seconds", "10 Seconds", "30 Seconds", "1 Minute", "2 Minutes", "3 Minutes", "5 Minutes", "8 Minutes", "10 Minutes", "15 Minutes", "30 Minutes", "60 Minutes"}));
        this.lbl_Interval.setText("Set your repeat interval");
        this.btn_Cancel.setText("Cancel SEED Checking");
        this.btn_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SEEDChecker.this.btn_CancelActionPerformed(evt);
            }
        });
        GroupLayout pnl_MainLayout = new GroupLayout(this.pnl_Main);
        this.pnl_Main.setLayout(pnl_MainLayout);
        pnl_MainLayout.setHorizontalGroup(pnl_MainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnl_MainLayout.createSequentialGroup().addContainerGap().addGroup(pnl_MainLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pnl_MainLayout.createSequentialGroup().addGroup(pnl_MainLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txt_titleID).addComponent(this.cbx_Interval, 0, 130, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(pnl_MainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnl_MainLayout.createSequentialGroup().addComponent(this.lbl_titleID, -2, 65, -2).addGap(64, 64, 64).addComponent(this.txt_Country, -2, 130, -2).addGap(18, 18, 18).addComponent(this.lbl_Country)).addComponent(this.lbl_Interval))).addGroup(pnl_MainLayout.createSequentialGroup().addComponent(this.btn_Check, -2, 165, -2).addGap(18, 18, 18).addComponent(this.btn_Cancel, -2, 165, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        pnl_MainLayout.setVerticalGroup(pnl_MainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnl_MainLayout.createSequentialGroup().addContainerGap().addGroup(pnl_MainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txt_titleID, -2, 35, -2).addComponent(this.lbl_titleID).addComponent(this.txt_Country, -2, 34, -2).addComponent(this.lbl_Country)).addGap(18, 18, 18).addGroup(pnl_MainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbx_Interval, -2, 35, -2).addComponent(this.lbl_Interval)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 92, Short.MAX_VALUE).addGroup(pnl_MainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btn_Check, -2, 35, -2).addComponent(this.btn_Cancel, -2, 35, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.pnl_Main, -2, -1, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.pnl_Main, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void txt_titleIDFocusGained(FocusEvent evt) {
    }

    private void txt_CountryFocusGained(FocusEvent evt) {
    }

    private void btn_CheckActionPerformed(ActionEvent evt) {
        int selectedInterval = this.cbx_Interval.getSelectedIndex();
        int[] selectedTime = new int[]{2, 5, 10, 30, 60, 120, 180, 300, 480, 600, 900, 1800, 3600};
        int time = selectedTime[selectedInterval] * 1000;
        String titleID = this.txt_titleID.getText();
        String country = this.txt_Country.getText();
        if (titleID.equals("") || country.equals("")) {
            JOptionPane.showMessageDialog(null, "Please fill out the TitleID and Country");
        } else {
            this.iniateTimer();
            this.timer.schedule((TimerTask)new FileDownloader(titleID, country), 0L, (long)time);
        }
    }

    private void btn_CancelActionPerformed(ActionEvent evt) {
        this.timer.cancel();
        this.timer.purge();
        this.iniateTimer();
        System.out.println("Timer canceled!");
    }

    private void formWindowOpened(WindowEvent evt) {
        this.setLocationRelativeTo(null);
    }
}

