/*
 * Decompiled with CFR 0.152.
 */
package pkg_seedchecker;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.TimerTask;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import pkg_seedchecker.ResultLogger;

public class FileDownloader
extends TimerTask {
    private final String titleID;
    private final String country;
    private final ResultLogger resultWindow = new ResultLogger();

    public FileDownloader() {
        this.titleID = "";
        this.country = "";
    }

    public FileDownloader(String titleID, String country) {
        this.titleID = titleID;
        this.country = country;
    }

    @Override
    public void run() {
        this.HttpsSeedChecker();
        this.resultWindow.txaLog.validate();
    }

    public void HttpsSeedChecker() {
        this.resultWindow.setVisible(true);
        String serverURL = "https://kagiya-ctr.cdn.nintendo.net/title/0x";
        String fileURL = "/ext_key?country=";
        String fullURL = serverURL + this.titleID + fileURL + this.country;
        String home = System.getProperty("user.home");
        Path target = Paths.get(home + "/Downloads/" + this.titleID + ".dat", new String[0]);
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (GeneralSecurityException sc) {
            // empty catch block
        }
        try {
            URL website = new URL(fullURL);
            try (InputStream in = website.openStream();){
                Files.copy(in, target, StandardCopyOption.REPLACE_EXISTING);
                this.resultWindow.txaLog.append(String.join((CharSequence)"", "Successfully downloaded SEED to " + target.toString()));
                this.resultWindow.txaLog.append("\n");
            }
        }
        catch (MalformedURLException ex) {
            System.out.println(ex);
        }
        catch (FileNotFoundException noseed) {
            this.resultWindow.txaLog.append(String.join((CharSequence)"", "No seed available for " + this.titleID + " in " + this.country));
            this.resultWindow.txaLog.append("\n");
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }
}

